document.addEventListener('DOMContentLoaded', () => {
    const rootNode = document.querySelector('.__testimonialsEmbla');
    if (!rootNode) {
        console.error('Root node not found');
        return;
    }
    const viewportNode = rootNode.querySelector('.__embla__viewport');
    const prevButtonNode = rootNode.querySelector('.__embla__prev');
    const nextButtonNode = rootNode.querySelector('.__embla__next');
    const contentNode = document.querySelector('.__testimonialContent');

    if (!viewportNode) {
        console.error('Viewport node not found');
        return;
    }
    // Testimonials Content Start
    const testimonials = [
        {
            text: 'Given previous bad experiences, I hesitated to try a new SEO services provider. However, I was pleasantly surprised. Attention to detail in SEO management helped more than double our traffic in just over two months. ',
            name: 'Charlotte Fielding',
            role: 'SEO specialist',
            rating: '4.9/5.0',
            avatar: 'https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/8d0c629f-f82d-4176-58bf-7951e3d13700/public',
            clutch: './assets/media/clutch.png'
        },
        {
            text: 'As an entrepreneur, I sought an SEO agency that could deliver tangible results. Jump to 1 surpassed my expectations with their proactive SEO management. They truly justified why they’re a leader in SEO services provision.',
            name: 'Oliver James',
            role: 'Owner, Innovative Retail Solutions ',
            rating: '4.8/5.0',
            avatar: 'https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/013d000b-f23e-442a-d705-bb379b8b9900/public',
            clutch: './assets/media/clutch.png'
        },
        {
            text: 'Jump to 1 revitalised my marketing strategy! Their accuracy in SEO targeting for our Google My Business listing was precisely what we needed, propelling us to the forefront of search rankings.',
            name: 'Sophie Turner',
            role: 'MD, Health First Clinics',
            rating: '4.7/5.0',
            avatar: 'https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/d73455c0-725b-4c42-6849-6254ea3d4f00/public',
            clutch: './assets/media/clutch.png'
        },
        {
            text: 'Engaging with them turned out to be a pivotal move for us. Their proficiency and tailored approach greatly enhanced our visibility and engagement, significantly improving our small business SEO marketing.',
            name: 'Thomas Elliot',
            role: 'Digital Strategy Lead, Sustainable Apparel Co',
            rating: '4.7/5.0',
            avatar: 'https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/8e485365-e726-42c7-0aa6-f3637a0c3d00/public',
            clutch: './assets/media/clutch.png'
        }
    ];
    // Testimonials Content End

    // Testimonials Content Tags Targeting
    const updateTestimonialContent = (index) => {
        const testimonial = testimonials[index];
        contentNode.querySelector('p').innerHTML = testimonial.text;
        contentNode.querySelector('h4').textContent = testimonial.name;
        contentNode.querySelector('span').textContent = testimonial.role;
        contentNode.querySelector('img[alt="avatar"]').src = testimonial.avatar;
        contentNode.querySelector('.d-flex.gap-2.align-items-end').innerHTML = `${testimonial.rating}<img src="${testimonial.clutch}" alt="clutch" class="d-block" />`;
    };
    // Testimonials Content Tags Targeting

    // Carousel Scroll Position
    const embla = EmblaCarousel(viewportNode, { axis: 'y', loop: true  });
    // Carousel Scroll Position

    // Autoplay 
    const autoplayInterval = 5000; 
    let autoplayTimer;
    // Autoplay 
    // Carousel Arrows Added Class Disabled
    const updateButtonStates = () => {
        if (prevButtonNode) {
            prevButtonNode.classList.toggle('is-disabled', !embla.canScrollPrev());
        }
        if (nextButtonNode) {
            nextButtonNode.classList.toggle('is-disabled', !embla.canScrollNext());
        }
    };
    // Carousel Arrows Added Class Disabled
    const autoplay = () => {
        clearInterval(autoplayTimer);
        autoplayTimer = setInterval(() => {
            embla.scrollNext();
        }, autoplayInterval);
    };
    // Carousel Slides Add Active
    const updateActiveSlide = () => {
        const selectedIndex = embla.selectedScrollSnap();
        const slides = embla.slideNodes();
        slides.forEach((slide, index) => {
            slide.classList.toggle('is-active', index === selectedIndex);
        });
        updateTestimonialContent(selectedIndex);
    };
    // Carousel Slides Add Active

    // Carousel Arrows Target Active
    embla.on('select', () => {
        updateActiveSlide();
        updateButtonStates();
    });

    embla.on('init', () => {
        updateActiveSlide();
        updateButtonStates();
        autoplay();
    });
    // Carousel Arrows Target Active

    // Carousel Arrows
    if (prevButtonNode) {
        prevButtonNode.addEventListener('click', () => embla.scrollPrev(), false);
    } else {
        console.error('Previous button not found');
    }

    if (nextButtonNode) {
        nextButtonNode.addEventListener('click', () => embla.scrollNext(), false);
    } else {
        console.error('Next button not found');
    }
    embla.on('pointerDown', () => {
        clearInterval(autoplayTimer);
    });
    embla.on('pointerUp', autoplay);
    // Carousel Arrows
});