document.addEventListener('DOMContentLoaded', () => {
    const rootNode = document.querySelector('.__resultsEmbla');
    const viewportNode = rootNode.querySelector('.__embla__viewport');
    // For Arrows
    // const prevButtonNode = rootNode.querySelector('.__embla__prev');
    // const nextButtonNode = rootNode.querySelector('.__embla__next');
    // For Arrows
    const dotsContainer = rootNode.querySelector('.__embla__dots');

    const embla = EmblaCarousel(viewportNode, { axis: 'x', loop: true  });

    const createDot = () => {
        const dot = document.createElement('button');
        dot.className = '__embla__dot';
        dotsContainer.appendChild(dot);
        return dot;
    };

    const dots = [];
    const slides = embla.slideNodes();
    slides.forEach(() => dots.push(createDot()));

    const selectDot = (index) => {
        dots.forEach((dot, i) => {
            dot.classList.toggle('is-selected', i === index);
        });
    };

    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => embla.scrollTo(index), false);
    });

    embla.on('select', () => selectDot(embla.selectedScrollSnap()));
    embla.on('init', () => selectDot(embla.selectedScrollSnap()));
    // For Arrows
    // prevButtonNode.addEventListener('click', () => embla.scrollPrev(), false);
    // nextButtonNode.addEventListener('click', () => embla.scrollNext(), false);
    // For Arrows
});