document.addEventListener('DOMContentLoaded', () => {
    const rootNode = document.querySelector('.__dominationEmbla');
    const viewportNode = rootNode.querySelector('.__embla__viewport');
    const dotsContainer = rootNode.querySelector('.__embla__dots');

    const embla = EmblaCarousel(viewportNode, { axis: 'x', loop: true });

    const autoplayInterval = 3000; 
    let autoplayTimer;

    const createDot = () => {
        const dot = document.createElement('button');
        dot.className = '__embla__dot';
        dotsContainer.appendChild(dot);
        return dot;
    };

    const dots = [];
    const slides = embla.slideNodes();
    slides.forEach(() => dots.push(createDot()));

    const selectDot = (index) => {
        dots.forEach((dot, i) => {
            dot.classList.toggle('is-selected', i === index);
        });
    };

    const autoplay = () => {
        clearInterval(autoplayTimer);
        autoplayTimer = setInterval(() => {
            embla.scrollNext();
        }, autoplayInterval);
    };

    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            embla.scrollTo(index);
            autoplay(); // Restart autoplay when a dot is clicked
        }, false);
    });

    embla.on('select', () => selectDot(embla.selectedScrollSnap()));
    embla.on('init', () => {
        selectDot(embla.selectedScrollSnap());
        autoplay(); // Start autoplay when initialized
    });

    // Restart autoplay when user interacts with the carousel
    embla.on('pointerDown', () => {
        clearInterval(autoplayTimer);
    });
    embla.on('pointerUp', autoplay);
});
