document.querySelectorAll(".num").forEach((valueDisplay) => {
    let startValue = 0;
    const endValue = parseInt(valueDisplay.getAttribute("data-val"));
    const duration = Math.floor(2000 / endValue);
    const [prefix, suffix] = valueDisplay.textContent.match(/^[^\d]*|\D*$/g);

    const counter = setInterval(() => {
        valueDisplay.textContent = `${prefix}${++startValue}${suffix}`;
        if (startValue === endValue) clearInterval(counter);
    }, duration);
});